# 🔍 VPN App Troubleshooting Guide

## Issue: "Failed to load servers"

![Error Screenshot](C:/Users/ARC/.gemini/antigravity/brain/821f39d8-4af3-47a4-b105-8b661b1fd28e/uploaded_image_1768241673502.png)

### Root Causes & Solutions

#### ✅ **Step 1: Configure API Key**

1. **Go to Admin Panel:**
   - URL: `https://vpn.upnews365.xyz/freevpn/admin`
   - Login with: `xantuf@gmail.com` / `AntorNusrat@@13`

2. **Navigate to "API Keys" section**

3. **Generate API Key if not done:**
   - Click "🔑 Generate New API Key"
   - App Name: "Free VPN App"
   - Usage Limit: Leave empty (unlimited)
   - Click "Generate"

4. **Copy the API Key** (long string like: `abc123def456...`)

5. **Assign Server to API:**
   - Click "🌐 Servers" button next to your API key
   - Check the box next to your server
   - Click "Save Server Access"

6. **Update ApiConfig.java:**
   ```java
   public static final String API_KEY = "paste_your_actual_api_key_here";
   ```

7. **Rebuild the app:**
   ```bash
   ./gradlew assembleDebug
   ```

---

#### ✅ **Step 2: Verify Server is Active**

In Admin Panel:
1. Go to "VPN Servers"
2. Check your server status is **"Active"** (green badge)
3. If inactive, click the "▶️ Enable" button

---

#### ✅ **Step 3: Test API Directly**

Open in browser:
```
https://vpn.upnews365.xyz/freevpn/api/servers.php?api_key=YOUR_API_KEY
```

**Expected Response:**
```json
{
  "success": true,
  "data": {
    "servers": [...],
    "total": 1
  }
}
```

**If you see error:**
- `INVALID_API_KEY` → API key is wrong
- `API_DISABLED` → API is disabled in admin
- `[]` (empty) → Server not assigned to API

---

#### ✅ **Step 4: Check Logcat (Android Studio)**

In Android Studio, check Logcat for errors:
```
Filter: "Retrofit" or "OkHttp"
```

Common errors:
- **SSL error** → API URL should use `https://`
- **401 Unauthorized** → API key is wrong
- **Empty response** → Server not assigned to API

---

## Quick Checklist

- [ ] API key is generated in admin panel
- [ ] API key is copied to `ApiConfig.java` (not "YOUR_API_KEY_HERE")
- [ ] Server is assigned to this API key (admin → API Keys → 🌐 Servers)
- [ ] Server status is "Active" (green)
- [ ] App is rebuilt after updating API key
- [ ] Internet connection is working on phone

---

## Most Common Fix

**99% of the time, the issue is:**

1. **API key not updated** - Still shows `YOUR_API_KEY_HERE` in code
2. **Server not assigned** - You created API but didn't assign the server to it

**Solution:**
```
Admin → API Keys → Click "🌐 Servers" → Check your server → Save
```

Then update `ApiConfig.java` with the actual API key and rebuild!
