# 📤 Server Upload Instructions

## Files to Upload to Your Server

You need to upload the entire `freevpn` folder to your server at: `public_html/freevpn/`

### 📁 Folder Structure on Server:

```
public_html/
└── freevpn/
    ├── config/
    │   ├── database.php
    │   └── config.php
    ├── admin/
    │   ├── login.php
    │   ├── dashboard.php
    │   ├── servers.php
    │   ├── api-keys.php
    │   ├── api-logs.php
    │   ├── settings.php
    │   ├── handlers/
    │   ├── includes/
    │   ├── css/
    │   └── js/
    ├── api/                    ⚠️ IMPORTANT - Create this folder!
    │   ├── servers.php
    │   ├── connect.php
    │   ├── index.php
    │   └── helpers/
    │       ├── auth.php
    │       └── response.php
    ├── database.sql
    └── logs/                   (will be auto-created)
```

## ✅ Upload Steps:

### Method 1: Using cPanel File Manager (Recommended)

1. **Login to cPanel**
2. **Open "File Manager"**
3. **Navigate to** `public_html`
4. **Upload** the entire `freevpn` folder from your desktop
5. **Extract** if you uploaded as ZIP

### Method 2: Using FTP (FileZilla)

1. **Connect via FTP** to your server
2. **Navigate to** `public_html/` or `www/`
3. **Upload** entire `freevpn` folder
4. **Keep folder structure** intact

### Method 3: Manual File Upload

If `api` folder doesn't exist on server:

1. Go to cPanel File Manager
2. Navigate to: `public_html/freevpn/`
3. **Create folder** named `api`
4. **Inside `api` folder**, create folder named `helpers`
5. Upload these files:
   - `api/servers.php` → Upload to `/api/`
   - `api/connect.php` → Upload to `/api/`
   - `api/index.php` → Upload to `/api/`
   - `api/helpers/auth.php` → Upload to `/api/helpers/`
   - `api/helpers/response.php` → Upload to `/api/helpers/`

---

## 🔧 After Upload - Verify Files:

Visit these URLs in browser:

1. **Admin Panel:** 
   `https://vpn.upnews365.xyz/freevpn/admin`
   - Should show login page ✅

2. **API Documentation:**
   `https://vpn.upnews365.xyz/freevpn/api/`
   - Should show API docs ✅

3. **Test API:**
   `https://vpn.upnews365.xyz/freevpn/api/servers.php?api_key=a14cd74d047545034799ef5c2b06aecdfdb222e9b9c90b1f807bf5e1df4bd568`
   - Should return JSON with servers ✅

---

## 🔐 Set Permissions (Important!)

After upload, set correct permissions:

**Via cPanel File Manager:**
1. **Files:** Select all `.php` files → Permissions → `644`
2. **Folders:** Select `admin`, `api`, `config` → Permissions → `755`
3. **Create** `logs` folder if not exists → Permissions → `755`
4. **Create** `uploads` folder if not exists → Permissions → `755`

**Via SSH/Terminal:**
```bash
cd public_html/freevpn
chmod 755 admin api config
chmod 644 *.php
chmod 755 logs uploads
```

---

## 📱 Update Android App After Upload:

Once API is live, update `ApiConfig.java`:

```java
public static final String BASE_URL = "https://vpn.upnews365.xyz/freevpn/api/";
```

Then rebuild the app!

---

## ❓ Common Upload Issues:

**Issue:** "404 Not Found" on API
- ✅ Check `api` folder exists
- ✅ Check files are inside `freevpn/api/`
- ✅ Check file names are correct (servers.php not Servers.php)

**Issue:** "403 Forbidden"
- ✅ Check file permissions (644 for files, 755 for folders)

**Issue:** "500 Internal Server Error"
- ✅ Check database connection in `config/database.php`
- ✅ Check PHP version (needs PHP 7.4+)
- ✅ Check error logs in cPanel

---

## 🎯 Quick Checklist:

- [ ] Upload entire `freevpn` folder to `public_html/`
- [ ] Verify `api` folder exists with all files
- [ ] Set file permissions (644/755)
- [ ] Test admin panel loads
- [ ] Test API URL returns JSON
- [ ] Update `ApiConfig.java` with correct URL
- [ ] Rebuild Android app

**After uploading, test the API URL and let me know what response you get!** 🚀
