<?php
$pageTitle = 'API Logs';
require_once __DIR__ . '/includes/header.php';

// Pagination
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$perPage = 50;
$offset = ($page - 1) * $perPage;

// Get API logs with pagination
try {
    $db = getDB();
    
    // Total count
    $totalLogs = $db->query("SELECT COUNT(*) FROM api_logs")->fetchColumn();
    $totalPages = ceil($totalLogs / $perPage);
    
    // Get logs
    $stmt = $db->prepare("
        SELECT 
            al.*,
            ak.app_name
        FROM api_logs al
        LEFT JOIN api_keys ak ON al.api_key = ak.api_key
        ORDER BY al.request_time DESC
        LIMIT ? OFFSET ?
    ");
    $stmt->execute([$perPage, $offset]);
    $logs = $stmt->fetchAll();
    
} catch (PDOException $e) {
    logActivity("API logs page error: " . $e->getMessage(), 'error');
    $logs = [];
    $totalLogs = 0;
    $totalPages = 0;
}
?>

<div class="card">
    <div class="card-header">
        <h2>API Request Logs (<?= number_format($totalLogs) ?>)</h2>
    </div>
    <div class="card-body">
        <?php if (empty($logs)): ?>
            <div class="empty-state">
                <div class="empty-icon">📝</div>
                <h3>No API logs yet</h3>
                <p>API requests will appear here once your apps start connecting</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Time</th>
                            <th>App Name</th>
                            <th>API Key</th>
                            <th>Device ID</th>
                            <th>Request Type</th>
                            <th>IP Address</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($logs as $log): ?>
                            <tr>
                                <td><?= date('M d, H:i:s', strtotime($log['request_time'])) ?></td>
                                <td><?= esc($log['app_name'] ?? 'Unknown') ?></td>
                                <td><code><?= esc(substr($log['api_key'], 0, 12)) ?>...</code></td>
                                <td><?= esc($log['device_id'] ?? '-') ?></td>
                                <td><?= esc($log['request_type']) ?></td>
                                <td><?= esc($log['ip_address']) ?></td>
                                <td>
                                    <span class="badge badge-<?= $log['response_status'] === 'success' ? 'success' : 'danger' ?>">
                                        <?= esc($log['response_status']) ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($totalPages > 1): ?>
                <div class="table-pagination" style="margin-top: 20px; text-align: center;">
                    <?php if ($page > 1): ?>
                        <a href="?page=<?= $page - 1 ?>" class="btn btn-sm btn-outline">← Previous</a>
                    <?php endif; ?>
                    
                    <span style="margin: 0 16px;">Page <?= $page ?> of <?= $totalPages ?></span>
                    
                    <?php if ($page < $totalPages): ?>
                        <a href="?page=<?= $page + 1 ?>" class="btn btn-sm btn-outline">Next →</a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
