<?php
require_once __DIR__ . '/../../config/config.php';
requireAuth();

if (!isset($_GET['csrf_token']) || !verifyCSRFToken($_GET['csrf_token'])) {
    header('Location: ../servers.php?error=' . urlencode('Invalid request'));
    exit;
}

$serverId = intval($_GET['id'] ?? 0);

if ($serverId <= 0) {
    header('Location: ../servers.php?error=' . urlencode('Invalid server ID'));
    exit;
}

try {
    $db = getDB();
    
    // Delete server (cascade will delete api_server_access entries)
    $stmt = $db->prepare("DELETE FROM vpn_servers WHERE id = ?");
    $stmt->execute([$serverId]);
    
    logActivity("Server deleted (ID: $serverId) by " . $_SESSION['admin_email']);
    
    header('Location: ../servers.php?success=' . urlencode('Server deleted successfully'));
} catch (PDOException $e) {
    logActivity("Delete server error: " . $e->getMessage(), 'error');
    header('Location: ../servers.php?error=' . urlencode('Failed to delete server'));
}
