<?php
require_once __DIR__ . '/../../config/config.php';
requireAuth();

header('Content-Type: application/json');

$apiId = intval($_GET['id'] ?? 0);

if ($apiId <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid API ID']);
    exit;
}

try {
    $db = getDB();
    $stmt = $db->prepare("SELECT server_id FROM api_server_access WHERE api_key_id = ?");
    $stmt->execute([$apiId]);
    $servers = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo json_encode([
        'success' => true,
        'servers' => $servers
    ]);
} catch (PDOException $e) {
    logActivity("Get API servers error: " . $e->getMessage(), 'error');
    echo json_encode([
        'success' => false,
        'message' => 'Database error'
    ]);
}
