<?php
require_once __DIR__ . '/../../config/config.php';
requireAuth();

header('Content-Type: application/json');

$serverId = intval($_GET['id'] ?? 0);

if ($serverId <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid server ID']);
    exit;
}

try {
    $db = getDB();
    $stmt = $db->prepare("SELECT ovpn_config FROM vpn_servers WHERE id = ?");
    $stmt->execute([$serverId]);
    $server = $stmt->fetch();
    
    if ($server) {
        echo json_encode([
            'success' => true,
            'config' => $server['ovpn_config']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Server not found'
        ]);
    }
} catch (PDOException $e) {
    logActivity("Get server config error: " . $e->getMessage(), 'error');
    echo json_encode([
        'success' => false,
        'message' => 'Database error'
    ]);
}
