<?php
require_once __DIR__ . '/../../config/config.php';
requireAuth();

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Admin Panel' ?> - VPN System</title>
    <link rel="stylesheet" href="css/admin.css">
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <h2>🚀 VPN Admin</h2>
                <p class="text-muted">v1.0</p>
            </div>
            
            <nav class="sidebar-nav">
                <a href="dashboard.php" class="nav-item <?= $currentPage === 'dashboard' ? 'active' : '' ?>">
                    <span class="nav-icon">📊</span>
                    <span class="nav-text">Dashboard</span>
                </a>
                
                <a href="servers.php" class="nav-item <?= $currentPage === 'servers' ? 'active' : '' ?>">
                    <span class="nav-icon">🌐</span>
                    <span class="nav-text">VPN Servers</span>
                </a>
                
                <a href="api-keys.php" class="nav-item <?= $currentPage === 'api-keys' ? 'active' : '' ?>">
                    <span class="nav-icon">🔑</span>
                    <span class="nav-text">API Keys</span>
                </a>
                
                <a href="api-logs.php" class="nav-item <?= $currentPage === 'api-logs' ? 'active' : '' ?>">
                    <span class="nav-icon">📝</span>
                    <span class="nav-text">API Logs</span>
                </a>
                
                <a href="settings.php" class="nav-item <?= $currentPage === 'settings' ? 'active' : '' ?>">
                    <span class="nav-icon">⚙️</span>
                    <span class="nav-text">Settings</span>
                </a>
            </nav>
            
            <div class="sidebar-footer">
                <div class="admin-info">
                    <p class="admin-name"><?= esc($_SESSION['admin_username']) ?></p>
                    <p class="admin-email"><?= esc($_SESSION['admin_email']) ?></p>
                </div>
                <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
            </div>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <div class="topbar">
                <div class="topbar-left">
                    <h1><?= $pageTitle ?? 'Admin Panel' ?></h1>
                </div>
                <div class="topbar-right">
                    <span class="badge badge-success">Online</span>
                    <span class="text-muted"><?= date('M d, Y H:i') ?></span>
                </div>
            </div>
            
            <div class="content-wrapper">
