<?php
$pageTitle = 'Settings';
require_once __DIR__ . '/includes/header.php';

// Handle settings update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf_token'])) {
    if (verifyCSRFToken($_POST['csrf_token'])) {
        $siteName = trim($_POST['site_name'] ?? '');
        
        try {
            $db = getDB();
            $stmt = $db->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'site_name'");
            $stmt->execute([$siteName]);
            
            $success = 'Settings updated successfully!';
        } catch (PDOException $e) {
            logActivity("Settings update error: " . $e->getMessage(), 'error');
            $error = 'Failed to update settings';
        }
    } else {
        $error = 'Invalid request';
    }
}

// Get current settings
try {
    $db = getDB();
    $stmt = $db->query("SELECT * FROM settings");
    $settingsRaw = $stmt->fetchAll();
    $settings = [];
    foreach ($settingsRaw as $setting) {
        $settings[$setting['setting_key']] = $setting['setting_value'];
    }
} catch (PDOException $e) {
    $settings = [];
}

$csrfToken = generateCSRFToken();
?>

<?php if (isset($success)): ?>
    <div class="alert alert-success"><?= esc($success) ?></div>
<?php endif; ?>

<?php if (isset($error)): ?>
    <div class="alert alert-error"><?= esc($error) ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <h2>System Settings</h2>
    </div>
    <div class="card-body">
        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?= esc($csrfToken) ?>">
            
            <div class="form-group">
                <label for="site_name">Site Name</label>
                <input type="text" id="site_name" name="site_name" 
                       value="<?= esc($settings['site_name'] ?? 'VPN Management System') ?>">
            </div>
            
            <div class="form-group">
                <label>API Base URL</label>
                <input type="text" readonly 
                       value="<?= SITE_URL ?>/api" 
                       onclick="this.select()">
                <small>Use this URL in your Android app</small>
            </div>
            
            <div class="form-group">
                <label>Admin Email</label>
                <input type="email" readonly value="<?= esc($_SESSION['admin_email']) ?>">
            </div>
            
            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h2>System Information</h2>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <tr>
                    <td><strong>PHP Version</strong></td>
                    <td><?= phpversion() ?></td>
                </tr>
                <tr>
                    <td><strong>Server Software</strong></td>
                    <td><?= $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown' ?></td>
                </tr>
                <tr>
                    <td><strong>Database</strong></td>
                    <td>MySQL / MariaDB</td>
                </tr>
                <tr>
                    <td><strong>Upload Max Size</strong></td>
                    <td><?= ini_get('upload_max_filesize') ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
