<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VPN API Documentation</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #333; margin-bottom: 10px; }
        .subtitle { color: #666; margin-bottom: 30px; }
        .endpoint {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        .method {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 4px;
            font-weight: bold;
            font-size: 12px;
            margin-right: 10px;
        }
        .get { background: #28a745; color: white; }
        .post { background: #007bff; color: white; }
        code {
            background: #2d2d2d;
            color: #f8f8f2;
            padding: 15px;
            display: block;
            border-radius: 6px;
            margin: 10px 0;
            overflow-x: auto;
        }
        .note {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 12px;
            margin: 15px 0;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 VPN System REST API</h1>
        <p class="subtitle">API Documentation for Android VPN Apps</p>
        
        <div class="note">
            <strong>Base URL:</strong> <?= htmlspecialchars((isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF'])) ?>
        </div>
        
        <div class="endpoint">
            <h2><span class="method get">GET</span> /servers.php</h2>
            <p><strong>Description:</strong> Get list of VPN servers assigned to your API key</p>
            
            <p><strong>Headers:</strong></p>
            <code>X-API-Key: YOUR_API_KEY
Authorization: Bearer YOUR_API_KEY (alternative)</code>
            
            <p><strong>Optional Parameters:</strong></p>
            <code>device_id (string): Unique device identifier</code>
            
            <p><strong>Response:</strong></p>
            <code>{
  "success": true,
  "data": {
    "servers": [
      {
        "id": 1,
        "server_name": "USA Server 1",
        "country": "United States",
        "flag_url": "https://...",
        "status": "active"
      }
    ],
    "total": 1
  }
}</code>
        </div>
        
        <div class="endpoint">
            <h2><span class="method post">POST</span> /connect.php</h2>
            <p><strong>Description:</strong> Get OpenVPN configuration for specific server</p>
            
            <p><strong>Headers:</strong></p>
            <code>X-API-Key: YOUR_API_KEY
Content-Type: application/json</code>
            
            <p><strong>Request Body:</strong></p>
            <code>{
  "server_id": 1,
  "device_id": "unique-device-id" (optional)
}</code>
            
            <p><strong>Response:</strong></p>
            <code>{
  "success": true,
  "data": {
    "server": {
      "id": 1,
      "server_name": "USA Server 1",
      "country": "United States",
      "flag_url": "https://...",
      "ovpn_config": "client\nremote ..."
    }
  }
}</code>
        </div>
        
        <div class="endpoint">
            <h2>Error Responses</h2>
            <code>{
  "success": false,
  "error": "Error message",
  "code": "ERROR_CODE"
}</code>
            
            <p><strong>Common Error Codes:</strong></p>
            <ul style="margin: 10px 0 10px 20px;">
                <li><code style="display: inline; padding: 2px 6px; margin: 0;">MISSING_API_KEY</code> - API key not provided</li>
                <li><code style="display: inline; padding: 2px 6px; margin: 0;">INVALID_API_KEY</code> - API key does not exist</li>
                <li><code style="display: inline; padding: 2px 6px; margin: 0;">API_DISABLED</code> - API key is disabled</li>
                <li><code style="display: inline; padding: 2px 6px; margin: 0;">LIMIT_EXCEEDED</code> - Daily usage limit exceeded</li>
                <li><code style="display: inline; padding: 2px 6px; margin: 0;">SERVER_NOT_ACCESSIBLE</code> - Server not assigned to this API</li>
            </ul>
        </div>
        
        <div class="note">
            <strong>Note:</strong> Get your API key from the <a href="../admin">Admin Panel</a>
        </div>
    </div>
</body>
</html>
